//
//  GSFileHandler.h
//  GlyphsKit
//
//  Created by Georg Seifert on 28.05.24.
//  Copyright © 2024 Georg Seifert. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface GSFileHandler : NSObject

/**
 Removes the specified directory and its contents asynchronously using Grand Central Dispatch (GCD).

 This method removes all files and subdirectories within the specified directory. It performs the removal operations asynchronously on a background queue to avoid blocking the main thread. The method waits for all removal tasks to complete before returning, ensuring that the directory and its contents are fully deleted.

 @param directoryPath The path of the directory to be removed. This path must not be `nil`.
 @param error A pointer to an `NSError` object. This parameter is optional and can be `nil`. If an error occurs during the removal process, this pointer will contain an error object describing the problem.

 @discussion This method uses `dispatch_group_t` to manage and synchronize concurrent removal tasks. Each subdirectory removal is dispatched to a global concurrent queue, and the method waits for all dispatched tasks to complete before returning. This ensures that the method does not return until the entire directory and its contents have been successfully removed. If any error occurs, the method returns `NO` and populates the `error` parameter with the relevant error information.

 */

+ (BOOL)removeDirectory:(NSString *)directoryPath error:(out NSError **)error;

@end

NS_ASSUME_NONNULL_END
